# Eric's AutoApply Chrome Extension

One-click tailored job applications powered by AI.

## Features

- 🎯 **Auto-Detect Jobs** - Automatically detects job postings on LinkedIn, Indeed, Glassdoor, ZipRecruiter
- ✨ **AI-Powered Generation** - Creates tailored resumes, cover letters, and email drafts
- 📄 **Multiple Formats** - Download as PDF or DOCX in 5 professional styles
- 🚀 **Auto-Fill** - Fills application forms automatically (Easy Apply support)
- 📊 **Track Applications** - Log and view your application history
- ⚙️ **Customizable** - Set daily limits, blacklist companies, choose preferred styles

## Installation

### Developer Mode (Recommended for now)

1. Open Chrome and go to `chrome://extensions/`
2. Enable "Developer mode" (top-right toggle)
3. Click "Load unpacked"
4. Select the `/var/www/job/extension` folder
5. The extension icon should appear in your toolbar

### Generate Icons

Before loading, generate PNG icons from the SVG:

```bash
# Using ImageMagick
convert -background none assets/icons/icon.svg -resize 16x16 assets/icons/icon16.png
convert -background none assets/icons/icon.svg -resize 48x48 assets/icons/icon48.png
convert -background none assets/icons/icon.svg -resize 128x128 assets/icons/icon128.png
```

Or use any SVG-to-PNG converter.

## Usage

1. **Login** - Click the extension icon and login with your job.exploit.team credentials
2. **Browse Jobs** - Visit any supported job site and navigate to a job posting
3. **Generate** - Click the green floating button that appears
4. **Review & Apply** - Preview your tailored materials, then apply!

## Supported Sites

| Site | Detection | Auto-Fill |
|------|-----------|-----------|
| LinkedIn | ✅ | Easy Apply |
| Indeed | ✅ | ✅ |
| Glassdoor | ✅ | Partial |
| ZipRecruiter | ✅ | ✅ |
| Other | Generic | Manual |

## Project Structure

```
extension/
├── manifest.json           # Extension config (Manifest V3)
├── background/
│   └── service-worker.js   # Background logic & API coordination
├── content/
│   ├── detector.js         # Job page detection & UI injection
│   ├── extractor.js        # Job data extraction classes
│   └── styles.css          # Injected UI styles
├── popup/
│   ├── popup.html/js/css   # Extension popup UI
├── options/
│   ├── options.html/js/css # Settings page
├── lib/
│   ├── api.js              # Eric's AutoApply API client
│   ├── storage.js          # Chrome storage wrapper
│   └── sites/              # Site-specific extractors
└── assets/icons/           # Extension icons
```

## API Integration

The extension communicates with `https://job.exploit.team/api`:

- `POST /api/auth/login` - Authentication
- `POST /api/generate/simple` - Generate application materials
- `POST /api/generate/download` - Download documents

## Settings

Access via extension icon → ⚙️ or right-click → Options:

- **Auto-fill only** - Fill forms without submitting
- **Daily limit** - Max applications per day (default: 20)
- **Preferred style** - Default document style
- **Company blacklist** - Skip specific companies

## Privacy

- Credentials stored locally in Chrome encrypted storage
- Application history stored locally
- Only job data sent to API for generation
- No tracking or analytics

## Development

```bash
# Watch for changes (requires live reload extension)
# Or manually reload extension after changes

# Test on job site
# 1. Go to linkedin.com/jobs or indeed.com
# 2. Open a job posting
# 3. Green FAB should appear
```

## License

Proprietary - exploit.team
