// Additional ATS and Job Board Extractors

// iCIMS ATS (used by many enterprises)
const ICIMSExtractor = {
    name: 'iCIMS',

    isJobPage() {
        return window.location.hostname.includes('icims.com') ||
            window.location.hostname.includes('careers-') ||
            document.querySelector('.iCIMS_JobHeader') !== null;
    },

    extract() {
        try {
            return {
                success: true,
                site: 'icims',
                title: document.querySelector('.iCIMS_JobTitle, h1')?.textContent.trim() || '',
                company: document.querySelector('.iCIMS_Company')?.textContent.trim() || '',
                location: document.querySelector('.iCIMS_JobLocation')?.textContent.trim() || '',
                description: document.querySelector('.iCIMS_JobDescription, .iCIMS_ExpandableText')?.textContent.trim() || '',
                hasDirectApply: !!document.querySelector('.iCIMS_ApplyButton, #applyButton'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'icims', error: error.message };
        }
    }
};

// BambooHR ATS
const BambooHRExtractor = {
    name: 'BambooHR',

    isJobPage() {
        return window.location.hostname.includes('bamboohr.com') ||
            document.querySelector('[data-testid="job-details"]') !== null;
    },

    extract() {
        try {
            return {
                success: true,
                site: 'bamboohr',
                title: document.querySelector('[data-testid="job-title"], h2.JobTitle, h1')?.textContent.trim() || '',
                company: document.querySelector('[data-testid="company-name"]')?.textContent.trim() || '',
                location: document.querySelector('[data-testid="job-location"], .location')?.textContent.trim() || '',
                description: document.querySelector('[data-testid="job-description"], .JobDesc')?.textContent.trim() || '',
                hasDirectApply: !!document.querySelector('[data-testid="apply-button"], .ApplyButton'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'bamboohr', error: error.message };
        }
    }
};

// SmartRecruiters ATS
const SmartRecruitersExtractor = {
    name: 'SmartRecruiters',

    isJobPage() {
        return window.location.hostname.includes('smartrecruiters.com') ||
            window.location.hostname.includes('jobs.smartrecruiters.com');
    },

    extract() {
        try {
            return {
                success: true,
                site: 'smartrecruiters',
                title: document.querySelector('h1.job-title, [data-automation="job-title"]')?.textContent.trim() || '',
                company: document.querySelector('.company-name, [data-automation="company-name"]')?.textContent.trim() || '',
                location: document.querySelector('.job-location, [data-automation="job-location"]')?.textContent.trim() || '',
                description: document.querySelector('.job-description, [data-automation="job-description"]')?.textContent.trim() || '',
                hasDirectApply: !!document.querySelector('.apply-btn, [data-automation="apply-button"]'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'smartrecruiters', error: error.message };
        }
    }
};

// JazzHR ATS
const JazzHRExtractor = {
    name: 'JazzHR',

    isJobPage() {
        return window.location.hostname.includes('applytojob.com') ||
            window.location.hostname.includes('jazz.co');
    },

    extract() {
        try {
            return {
                success: true,
                site: 'jazzhr',
                title: document.querySelector('#job-title, h1.job-title')?.textContent.trim() || '',
                company: document.querySelector('.company-name')?.textContent.trim() || '',
                location: document.querySelector('#job-location, .location')?.textContent.trim() || '',
                description: document.querySelector('#job-description, .description')?.textContent.trim() || '',
                hasDirectApply: !!document.querySelector('#apply-button, .apply-btn'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'jazzhr', error: error.message };
        }
    }
};

// BuiltIn (tech jobs by city)
const BuiltInExtractor = {
    name: 'BuiltIn',

    isJobPage() {
        return window.location.hostname.includes('builtin.com') &&
            window.location.pathname.includes('/job/');
    },

    extract() {
        try {
            return {
                success: true,
                site: 'builtin',
                title: document.querySelector('h1.job-title, [data-id="job-title"]')?.textContent.trim() || '',
                company: document.querySelector('.company-name, [data-id="company-name"]')?.textContent.trim() || '',
                location: document.querySelector('.location, [data-id="location"]')?.textContent.trim() || '',
                description: document.querySelector('.job-description, [data-id="job-description"]')?.textContent.trim() || '',
                hasDirectApply: !!document.querySelector('.apply-button, [data-id="apply"]'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'builtin', error: error.message };
        }
    }
};

// SimplyHired
const SimplyHiredExtractor = {
    name: 'SimplyHired',

    isJobPage() {
        return window.location.hostname.includes('simplyhired.com') &&
            (window.location.pathname.includes('/job/') ||
                document.querySelector('.viewjob-content') !== null);
    },

    extract() {
        try {
            return {
                success: true,
                site: 'simplyhired',
                title: document.querySelector('h1.viewjob-jobTitle, h2[data-testid="viewJobTitle"]')?.textContent.trim() || '',
                company: document.querySelector('.viewjob-company, [data-testid="viewJobCompany"]')?.textContent.trim() || '',
                location: document.querySelector('.viewjob-labelWithIcon, [data-testid="viewJobLocation"]')?.textContent.trim() || '',
                description: document.querySelector('.viewjob-description, [data-testid="viewJobDescription"]')?.textContent.trim() || '',
                hasDirectApply: !!document.querySelector('.viewjob-apply, [data-testid="applyButton"]'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'simplyhired', error: error.message };
        }
    }
};

// The Muse
const TheMuseExtractor = {
    name: 'TheMuse',

    isJobPage() {
        return window.location.hostname.includes('themuse.com') &&
            window.location.pathname.includes('/jobs/');
    },

    extract() {
        try {
            return {
                success: true,
                site: 'themuse',
                title: document.querySelector('h1.job-board-job-title')?.textContent.trim() || '',
                company: document.querySelector('.company-name, .job-board-company')?.textContent.trim() || '',
                location: document.querySelector('.job-location, .location')?.textContent.trim() || '',
                description: document.querySelector('.job-description, .job-board-description')?.textContent.trim() || '',
                hasDirectApply: !!document.querySelector('.apply-button'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'themuse', error: error.message };
        }
    }
};

// Hired.com
const HiredExtractor = {
    name: 'Hired',

    isJobPage() {
        return window.location.hostname.includes('hired.com') &&
            window.location.pathname.includes('/jobs/');
    },

    extract() {
        try {
            return {
                success: true,
                site: 'hired',
                title: document.querySelector('h1[class*="title"], .job-title')?.textContent.trim() || '',
                company: document.querySelector('[class*="company"], .company-name')?.textContent.trim() || '',
                location: document.querySelector('[class*="location"]')?.textContent.trim() || '',
                description: document.querySelector('[class*="description"], .job-description')?.textContent.trim() || '',
                hasDirectApply: true, // Hired is application-based
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'hired', error: error.message };
        }
    }
};

export {
    ICIMSExtractor,
    BambooHRExtractor,
    SmartRecruitersExtractor,
    JazzHRExtractor,
    BuiltInExtractor,
    SimplyHiredExtractor,
    TheMuseExtractor,
    HiredExtractor
};
