// CareerBuilder Extractor
// Major job board

const CareerBuilderExtractor = {
    name: 'CareerBuilder',

    isJobPage() {
        return window.location.hostname.includes('careerbuilder.com') &&
            (window.location.pathname.includes('/job/') ||
                document.querySelector('.data-details-title') !== null);
    },

    extract() {
        try {
            const title = document.querySelector('.data-details-title, h1.job-title, [data-testid="job-title"]')?.textContent.trim() || '';

            const company = document.querySelector('.data-details-company, .company-name, [data-testid="company-name"]')?.textContent.trim() || '';

            const location = document.querySelector('.data-details-location, .job-location')?.textContent.trim() || '';

            const description = document.querySelector('.data-details-description, .job-description, #job-description')?.textContent.trim() || '';

            return {
                success: true,
                site: 'careerbuilder',
                title,
                company,
                location,
                description,
                hasDirectApply: !!document.querySelector('.data-details-apply, .apply-button'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'careerbuilder', error: error.message };
        }
    }
};

export default CareerBuilderExtractor;
