// Dice Extractor
// Tech-focused job board

const DiceExtractor = {
    name: 'Dice',

    isJobPage() {
        return window.location.hostname.includes('dice.com') &&
            (window.location.pathname.includes('/job-detail/') ||
                document.querySelector('[data-cy="jobTitle"]') !== null);
    },

    extract() {
        try {
            const title = document.querySelector('[data-cy="jobTitle"], h1.jobTitle, .job-title')?.textContent.trim() || '';

            const company = document.querySelector('[data-cy="companyName"], .employer-name, .companyName')?.textContent.trim() || '';

            const location = document.querySelector('[data-cy="location"], .location, [class*="location"]')?.textContent.trim() || '';

            const description = document.querySelector('[data-cy="jobDescription"], .job-description, #jobDescription')?.textContent.trim() || '';

            const skills = Array.from(document.querySelectorAll('[data-cy="skill"], .skill-badge'))
                .map(el => el.textContent.trim());

            return {
                success: true,
                site: 'dice',
                title,
                company,
                location,
                description,
                skills,
                hasDirectApply: !!document.querySelector('[data-cy="applyButton"], .apply-btn'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'dice', error: error.message };
        }
    }
};

export default DiceExtractor;
