// Monster Job Extractor
// Major job board

const MonsterExtractor = {
    name: 'Monster',

    isJobPage() {
        return window.location.hostname.includes('monster.com') &&
            (window.location.pathname.includes('/job-openings/') ||
                window.location.pathname.includes('/jobs/') ||
                document.querySelector('[data-testid="jobTitle"]') !== null);
    },

    extract() {
        try {
            const title = document.querySelector('[data-testid="jobTitle"], .JobViewTitle, h1')?.textContent.trim() || '';

            const company = document.querySelector('[data-testid="company"], .company-name, [class*="companyName"]')?.textContent.trim() || '';

            const location = document.querySelector('[data-testid="jobDetailLocation"], .location, [class*="location"]')?.textContent.trim() || '';

            const description = document.querySelector('[data-testid="jobDescription"], .job-description, #JobDescription')?.textContent.trim() || '';

            const salary = document.querySelector('[data-testid="salaryEstimate"], .salary')?.textContent.trim() || '';

            return {
                success: true,
                site: 'monster',
                title,
                company,
                location,
                description,
                salary,
                hasDirectApply: !!document.querySelector('[data-testid="applyButton"], .apply-button, #applyButton'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'monster', error: error.message };
        }
    }
};

export default MonsterExtractor;
