// Remote Job Board Extractors
// Supports RemoteOK, WeWorkRemotely, and FlexJobs

// RemoteOK Extractor
const RemoteOKExtractor = {
    name: 'RemoteOK',

    isJobPage() {
        return window.location.hostname.includes('remoteok.com') ||
            window.location.hostname.includes('remoteok.io');
    },

    extract() {
        try {
            const jobRow = document.querySelector('.job, [itemtype*="JobPosting"], .expandContents');
            const title = document.querySelector('[itemprop="title"], h2, .company a:last-child')?.textContent.trim() || '';
            const company = document.querySelector('[itemprop="hiringOrganization"], h3.company, .company a:first-child')?.textContent.trim() || '';
            const location = document.querySelector('[itemprop="jobLocation"], .location')?.textContent.trim() || 'Remote';
            const description = document.querySelector('[itemprop="description"], .description, .markdown')?.textContent.trim() || '';
            const salary = document.querySelector('.salary')?.textContent.trim() || '';
            const tags = Array.from(document.querySelectorAll('.tag, .tags a')).map(t => t.textContent.trim());

            return {
                success: true,
                site: 'remoteok',
                title,
                company,
                location,
                description,
                salary,
                tags,
                hasDirectApply: !!document.querySelector('.apply, a[href*="apply"]'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'remoteok', error: error.message };
        }
    }
};

// WeWorkRemotely Extractor
const WeWorkRemotelyExtractor = {
    name: 'WeWorkRemotely',

    isJobPage() {
        return window.location.hostname.includes('weworkremotely.com') &&
            window.location.pathname.includes('/remote-jobs/');
    },

    extract() {
        try {
            const title = document.querySelector('h1, .listing-header-container h1')?.textContent.trim() || '';
            const company = document.querySelector('.company, .listing-header-container .company')?.textContent.trim() || '';
            const location = document.querySelector('.region, .listing-tag')?.textContent.trim() || 'Remote';
            const description = document.querySelector('.listing-container, .job-description')?.textContent.trim() || '';
            const category = document.querySelector('.category')?.textContent.trim() || '';

            return {
                success: true,
                site: 'weworkremotely',
                title,
                company,
                location,
                description,
                category,
                hasDirectApply: !!document.querySelector('.apply-button, a[href*="apply"]'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'weworkremotely', error: error.message };
        }
    }
};

// FlexJobs Extractor
const FlexJobsExtractor = {
    name: 'FlexJobs',

    isJobPage() {
        return window.location.hostname.includes('flexjobs.com') &&
            window.location.pathname.includes('/jobs/');
    },

    extract() {
        try {
            const title = document.querySelector('h1.job-title, .job-heading h1')?.textContent.trim() || '';
            const company = document.querySelector('.job-company, .company-name')?.textContent.trim() || '';
            const location = document.querySelector('.job-location, .location')?.textContent.trim() || '';
            const description = document.querySelector('.job-description, #job-description')?.textContent.trim() || '';
            const jobType = document.querySelector('.job-type, .schedule')?.textContent.trim() || '';

            return {
                success: true,
                site: 'flexjobs',
                title,
                company,
                location,
                description,
                jobType,
                hasDirectApply: !!document.querySelector('.apply-btn, .apply-button'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'flexjobs', error: error.message };
        }
    }
};

export { RemoteOKExtractor, WeWorkRemotelyExtractor, FlexJobsExtractor };
