// Wellfound (formerly AngelList) Extractor
// Startup job board

const WellfoundExtractor = {
    name: 'Wellfound',

    isJobPage() {
        return window.location.hostname.includes('wellfound.com') ||
            window.location.hostname.includes('angel.co') &&
            (window.location.pathname.includes('/jobs/') ||
                window.location.pathname.includes('/role/'));
    },

    extract() {
        try {
            const title = document.querySelector('[data-test="JobTitle"], h1[class*="title"], .job-title')?.textContent.trim() || '';

            const company = document.querySelector('[data-test="CompanyName"], a[class*="company"], .company-name')?.textContent.trim() || '';

            const location = document.querySelector('[data-test="Location"], [class*="location"]')?.textContent.trim() || '';

            const description = document.querySelector('[data-test="JobDescription"], .job-description, [class*="description"]')?.textContent.trim() || '';

            const salary = document.querySelector('[data-test="Compensation"], .salary-range')?.textContent.trim() || '';

            const equity = document.querySelector('[data-test="Equity"]')?.textContent.trim() || '';

            return {
                success: true,
                site: 'wellfound',
                title,
                company,
                location,
                description,
                salary,
                equity,
                hasDirectApply: !!document.querySelector('button[class*="apply"], [data-test="ApplyButton"]'),
                jobUrl: window.location.href
            };
        } catch (error) {
            return { success: false, site: 'wellfound', error: error.message };
        }
    }
};

export default WellfoundExtractor;
